$Title: (8) Split Value added to Land and Water for GTAP water 2011

*       ----------------------------------------------------------------       *
*                                                                              *
*                   Global Trade Analysis Project                              *
*                       GTAP Water database                                    *
*        (8)   Estimate Water Value Added by River Basin for 2011              *
*                                                                              *
*       ----------------------------------------------------------------       *

* ---------------- FT Formula (origianl method) --------------------------------
parameters
  vfml_i      irrigated yield
  vfml_r      rain fed yield
  vfmld       yield difference
  WatVFM
  shr_wat
  shr_wat1
  check;

vfml_i(a,b,c,r)$hi(a,b,c,r) = vfm_('IrrWL',a,b,c,r) / hi(a,b,c,r) ;
vfml_r(a,b,c,r)$hr(a,b,c,r) = vfm_('RfdLand',a,b,c,r) / hr(a,b,c,r) ;

vfmld(a,b,c,r)$(vfml_i(a,b,c,r)-vfml_r(a,b,c,r) lt 0)
  =0.1*vfml_i(a,b,c,r);

vfmld(a,b,c,r)$(vfml_i(a,b,c,r)-vfml_r(a,b,c,r) eq 0)
  =0.1*vfml_i(a,b,c,r);

vfmld(a,b,c,r)$(vfml_i(a,b,c,r)-vfml_r(a,b,c,r) gt 0)
  =0.1*vfml_i(a,b,c,r) + 0.9*(vfml_i(a,b,c,r)-vfml_r(a,b,c,r));

vfmld(a,b,c,r)$(vfml_i(a,b,c,r) gt 0 and vfml_r(a,b,c,r) eq 0)
  =0.9*vfml_i(a,b,c,r);

vfmld(a,b,c,r)$(vfml_i(a,b,c,r) eq 0 and vfml_r(a,b,c,r) eq 0)
  =0.0;

vfm_('water',a,b,c,r)$(%Method% = 0) = vfmld(a,b,c,r)*hi(a,b,c,r);

shr_wat(a,b,c,r) = eps;
shr_wat(a,b,c,r)$(vfm_('IrrWL',a,b,c,r) > eps) = vfm_('water',a,b,c,r)/vfm_('IrrWL',a,b,c,r);
check('ft0_lt000',a,b,c,r)$(shr_wat(a,b,c,r) < 0.00) = 1;
check('ft0_gt090',a,b,c,r)$(shr_wat(a,b,c,r) > 0.90) = 1;
check('ft0_gt100',a,b,c,r)$(shr_wat(a,b,c,r) > 1.00) = 1;
check('nonzeroreg',a,b,c,r)$(hi(a,b,c,r) > eps) = 1;


* Define limits for water share in Lnad VA
$setGlobal WatShr_min    0.1
$setGlobal WatShr_max    0.9
$setGlobal WatShr_avg    0.1


* ---------------- Alternative Formula (1) -----------------------------------
WatVFM(a,b,c,r) = (vfml_i(a,b,c,r) - vfml_r(a,b,c,r)) * hi(a,b,c,r);

shr_wat1(a,b,c,r) = eps;
shr_wat1(a,b,c,r)$(vfm_('IrrWL',a,b,c,r) > eps) = WatVFM(a,b,c,r)/vfm_('IrrWL',a,b,c,r);

check('ft1_lt000',a,b,c,r)$(shr_wat1(a,b,c,r) < %WatShr_min%) = 1;
check('ft1_gt090',a,b,c,r)$(shr_wat1(a,b,c,r) > %WatShr_max%) = 1;
check('ft1_gt100',a,b,c,r)$(shr_wat1(a,b,c,r) > 1) = 1;

shr_wat1(a,b,c,r)$(shr_wat1(a,b,c,r) < %WatShr_min%) = %WatShr_min%;
shr_wat1(a,b,c,r)$(shr_wat1(a,b,c,r) > %WatShr_max%) = %WatShr_max%;

vfm_('water',a,b,c,r)$(%Method% = 1) = shr_wat1(a,b,c,r) * vfm_('IrrWL',a,b,c,r);

*-------------------------------------------------------------------------


* ---------------- Alternative Formula (2)-----------------------------------
parameter shr_wat2;
shr_wat2(a,b,c,r) = eps;
shr_wat2(a,b,c,r)$(qi(a,b,c,r)*hr(a,b,c,r)) =
     1- (qr(a,b,c,r)*hi(a,b,c,r))/ (qi(a,b,c,r)*hr(a,b,c,r));

check('ih_lt000',a,b,c,r)$(shr_wat2(a,b,c,r) < %WatShr_min%) = 1;
check('ih_gt090',a,b,c,r)$(shr_wat2(a,b,c,r) > %WatShr_max%) = 1;
check('ih_gt100',a,b,c,r)$(shr_wat2(a,b,c,r) > 1) = 1;

shr_wat2(a,b,c,r)$(shr_wat2(a,b,c,r) < %WatShr_min%) = %WatShr_min%;
shr_wat2(a,b,c,r)$(shr_wat2(a,b,c,r) > %WatShr_max%) = %WatShr_max%;

vfm_('water',a,b,c,r)$(%Method% = 2) = shr_wat2(a,b,c,r) * vfm_('IrrWL',a,b,c,r);


* -------------------- calculate vfm_, evfa_, evoa_ -------------------------*
evfa_('water',a,b,c,r) = rTFi(a,b,c,r) * vfm_('water',a,b,c,r);

 vfm_('IrrLand',a,b,c,r)=  vfm_('IrrWL',a,b,c,r) -  vfm_('water',a,b,c,r);
evfa_('IrrLand',a,b,c,r)= evfa_('IrrWL',a,b,c,r) - evfa_('water',a,b,c,r);

evoa_('IrrLand',a,b,r) =
     taxevoa('land',r)*sum(agr, vfm_('IrrLand',a,b,agr,r) );

evoa_('Water',a,b,r) =
     taxevoa('land',r)*sum(agr, vfm_('Water',a,b,agr,r) );

evoa_('OthLand',a,b,r) =
     taxevoa('land',r)*sum(agr, vfm_('OthLand',a,b,agr,r) );

evoa_('RfdLand',a,b,r) =
     taxevoa('land',r)*sum(agr, vfm_('RfdLand',a,b,agr,r) );

parameter shr_water;
shr_water(a,b,c,r) = eps;
shr_water(a,b,c,r)$(vfm_('IrrWL',a,b,c,r) gt eps) = vfm_('water',a,b,c,r)/vfm_('IrrWL',a,b,c,r);

 vfm_('IrrWL',a,b,c,r)=0;
evfa_('IrrWL',a,b,c,r)=0;
evoa_('IrrWL',a,b,r)=0;


set label /IrrLand,Water,OthLand,RfdLand/;


 vfm_(label,a,b,agr,r)$( vfm_(label,a,b,agr,r) lt 1e-7) = 0;
evfa_(label,a,b,agr,r)$(evfa_(label,a,b,agr,r) lt 1e-7) = 0;
evoa_(label,a,b,r)  $(evoa_(label,a,b,  r) lt 1e-7) = 0;

 vfm_(label,a,b,agr,r)$( vfm_(label,a,b,agr,r) = eps) = 0;
evfa_(label,a,b,agr,r)$(evfa_(label,a,b,agr,r) = eps) = 0;
evoa_(label,a,b,r)  $(evoa_(label,a,b,  r) = eps) = 0;


display vfm_, evfa_, evoa_;

* I use the following excel file to find basin mappings. It needs excel work!
*execute_unload 'LandVA_rbaez.gdx' vfm_, evfa_, evoa_;
*execute "gdxxrw  LandVA_rbaez.gdx o=../%AggrName%in/VAbyRB.xlsx par=vfm_  Rng=VFM!a2 rdim=5 cdim=0";
*execute "gdxxrw  LandVA_rbaez.gdx o=../%AggrName%in/VAbyRB.xlsx par=evfa_ Rng=VFA!a2 rdim=5 cdim=0";
*execute "gdxxrw  LandVA_rbaez.gdx o=../%AggrName%in/VAbyRB.xlsx par=evoa_ Rng=VOA!a2 rdim=4 cdim=0";
